@echo off
set FWFILE=etport-external-2.40.frm
set TIMEOUT=5

echo.

net session > nul 2>&1
if %errorlevel%==0 (
  goto start
) else (
  echo ERROR: Administrative priviliges required.
  echo        Please run this script or command line terminal with Administrative Permissions ^(ie: "Run as Administrator"^)
  echo.
  pause 
  goto end
)

:start
if [%1]==[] (
  cd "%~dp0%"
  echo.
  echo -------------- Available Network Interfaces ---------------------------------
  netsh interface ipv4 show config |findstr "Configuration"
  echo -----------------------------------------------------------------------------
  echo Please select the name of the ethernet interface to which the meter is directly connected.
  echo.
  echo In the command prompt below, 
  echo Please run the batch file with the interface name as a parameter INCLUDING QUOTES.
  echo   eg: 
  echo       recover_ETport.bat "Ethernet"
  echo. 
  
  cmd.exe
  

  rem start /D "%~dp0%" cmd.exe list.bat
  
  goto end
) else (
  echo Ensure that the ETport is in Bootloader Mode:
  echo    1^) Power Off the ETport
  echo    2^) Press and HOLD the "Reset" button while power up the ETport
  echo    3^) Wait 5-10 seconds after powering up the ETport
  echo    4^) The STATUS LED should alternate red/green after a few seconds
  echo    5^) Plug an ethernet cable directly form the ETport to the PC/Laptop
  echo.
  echo Press any key when the above has been completed and ready to proceed....
  pause >nul

  echo.
  echo Configuring %1, for setting static address 10.10.10.10
  netsh interface ipv4 set address name=%1 source=static address=10.10.10.11 mask=255.255.255.0 gateway=10.10.10.10 store=active
  
  echo Waiting %TIMEOUT% seconds for changes to take affect.
  timeout /t %TIMEOUT%  /nobreak
  echo.

  echo Testing connection...Pinging ETport....
ping 10.10.10.10 -n 1 -w 1000|find "TTL="  
if errorlevel 1 (
  echo FAIL
  goto ConnectionFail
) else (
  echo SUCCESS
  goto ConnectionOK
)

  :ConnectionOk
  echo.
  echo Meter Connection Successful.
  echo STARTING UPDATE, do NOT power off the meter.
  echo.

  tftpc.exe -i 10.10.10.10 PUT %FWFILE%
  if %errorlevel%==1 goto UpdateFail
  echo.
  echo TFTP of Firmware File %FWFILE% Success.
  echo Resetting %1 interface....You may now disconnect your PC/Laptop
  echo.
  netsh interface ipv4 set address name=%1 source=dhcp
  echo Please wait 3 minutes ^(180 sec^) for the update to install.
  timeout /t 180 /nobreak  
  echo.
  echo Last Steps:  
  echo   - Reconnect the ETport to the LAN ^(instead of the PC/Laptop^)
  echo   - Power cycle the ETport.
  echo.
  echo   - NOTE: This PC's ethernet interface has been reset to "DHCP".  
  echo     If this is not correct, you will need to configure it manually.
  echo.

  echo Firmware Update Complete.
  echo. 
  goto end
)

goto end

:ConnectionFail
echo ERROR: Connection to 10.10.10.10 (ETport) could not be established
echo Update failed
echo.
goto end

:UpdateFail
echo.
echo UPDATE: FAILED.  Please review messages and try again.
goto end

:NoConnection
echo No Connection to the meter detected.  Try Again

:end